#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)49   1.10   src/csm/director/pm/DirectorUtils.pm.perl, csm.director, csm_rameh, rameh_base 4/5/04 15:47:08
######################################################################
#                                                                    #
# Module: DirectorUtils.pm                                           #
#                                                                    #
######################################################################
#                                                                    #
# Description: Common functions used in Director perl scripts        #
#                                                                    #
######################################################################
package DirectorUtils;

use strict;

use ArchiveUtils;

BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    @ISA         = qw(Exporter);
    @EXPORT      = qw();
    %EXPORT_TAGS = ( );         # eg: TAG => [ qw!name1 name2! ],

    # your exported package globals go here,
    # as well as any optionally exported functions
    @EXPORT_OK   = qw(&getTWGDIR &DirectorStatus
                      &DirectorStart &DirectorStop
                      &determine_installed_sw
                      $TWG_DIR $VERBOSE);
}

our $TWG_DIR = "";
our $VERBOSE = 0;

our $RPM      ="/bin/rpm";
our $rpmquery ="$RPM --query";
our $queryfmt ="--queryformat \"%{NAME} %{VERSION} %{RELEASE} %{ARCH}\\n\"";

###############################################################################
# getTWGDIR()
#
# Determine top level directory for IBM Director install
###############################################################################
sub getTWGDIR {
    if ($TWG_DIR ne "") { return $TWG_DIR; }

    # Determine location of IBM Director
    my($arch, $configFile);
   
    $arch = ArchiveUtils->get_PkgArchitecture;
    if ( $arch =~ /i.86/) { # x86 architecture
        if (-f "/etc/TWGserver/TWGserver") {
            $configFile = "/etc/TWGserver/TWGserver";
        }
        elsif (-f "/etc/TWGagent/TWGagent") {
            $configFile = "/etc/TWGagent/TWGagent";
        }
        else { $TWG_DIR = ""; return $TWG_DIR; }
    }
    else { # ppc architecture
        if (-f "/etc/ibm/director/twgagent/twgagent") {
            $configFile = "/etc/ibm/director/twgagent/twgagent";
        }
        else { $TWG_DIR = ""; return $TWG_DIR; }
    }

    if (!open(TWGCONFIG, $configFile)) {
        $TWG_DIR = ""; return $TWG_DIR;;
    }
    else {
        my($line);
        while ($line = <TWGCONFIG>) {
            chomp($line);
            if ($line =~ /^\s*TWG_ROOTDIR\s*=\s*(\S+)\s*$/) {
                $TWG_DIR = $1;
            }
        }
    }
    close TWGCONFIG;

    print "Director root: $TWG_DIR\n" if $VERBOSE >= 2;
    return $TWG_DIR;
}


###############################################################################
# DirectorStatus()
#
# Returns Director Status:
#  -1 : Error, Director not installed, twgstat failed, other errors that
#              prevent determining status
#   0 : Inactive (stopped either from error or normally)
#   1 : Active (active, starting, or ending)
###############################################################################
sub DirectorStatus {
    getTWGDIR();
    if ($TWG_DIR eq "") { return -1; }

    # Determine agent status
    print "$TWG_DIR/bin/twgstat\n" if ($VERBOSE >= 3);
    `/bin/sh -c "$TWG_DIR/bin/twgstat > /dev/null 2>&1"`;
    my($rc) = $? >> 8;

    if ($? && $rc == 0)                   { return -1; }
    if ($rc == 0 || $rc == 1 || $rc == 2) { return  1; }
    if ($rc == 3 || $rc == 4)             { return  0; }

    return -1;
}


######################################################################
# ask_stop_director
#     Check to see if director server/agent should be stopped
######################################################################
sub ask_stop_director {
    my ($restarted_name) = @_;
    if ($::restart_director != -1) { return $::restart_director; }
    if (! -t STDIN) { return 1; }

    if (!open(DEVTTY, "+<", "/dev/tty")) {
        return 1;
    }
    my $yn = "x";
    while ($yn ne "n" && $yn ne "N" &&
	   $yn ne "y" && $yn ne "Y") {
        print DEVTTY "$::progname: Ok to temporarily stop $restarted_name now? (y/n): ";
	chomp($yn = <DEVTTY>);
    }
    close(DEVTTY);
    if ($yn eq "y" || $yn eq "Y") { $::restart_director = 1; return 1; }

    print "$::progname: Cannot continue while $restarted_name is running.\n";
    exit(96);
}


###############################################################################
# DirectorStop()
#
# Stop and wait for termination of Director
###############################################################################
sub DirectorStop {
    my ($restarted_name) = @_;
    getTWGDIR();

    # Stop director
    print "$::progname: Stopping $restarted_name...";
    print "\n$TWG_DIR/bin/twgend\n" if ($VERBOSE >= 3);
    my ($output) = `/bin/sh -c "$TWG_DIR/bin/twgend 2>&1"`;

    # Wait for it to shut down before continuing
    my($rc) = 0;
    my($timeout_count) = 0;
    while ($rc != 3) {
        if ($VERBOSE >= 3) { print "$TWG_DIR/bin/twgstat\n"; }
        else { print("."); }
        `/bin/sh -c "$TWG_DIR/bin/twgstat > /dev/null 2>&1"`;
        $rc = $? >> 8;
        print "twgstat rc=$rc\n" if ($VERBOSE >= 3);
        if ($timeout_count++ > 60) {
            print "\n$::progname: Timeout stopping $restarted_name.\n";
            exit(96);
        }
    }
    print(" Stopped.\n");
}


###############################################################################
# DirectorStart()
#
# Start IBM Director
###############################################################################
sub DirectorStart {
    getTWGDIR();

    # Make sure agent is shut down before continuing
    print "\n$TWG_DIR/bin/twgstart\n" if ($VERBOSE >= 3);
    my ($output) = `/bin/sh -c "$TWG_DIR/bin/twgstart 2>&1"`;
    my($rc) = $? << 8;
    if ($rc)
    {
        print "$::progname: Error starting IBM Director\n\t$output\n";
    }
}


######################################################################
# determine_installed_sw()
#
#     locate/identify currently installed RPMs
#
# Args: list of RPMS
# Returns: hash of RPM name => (version, release)
######################################################################
sub determine_installed_sw {
    my ($pkgs_to_query) = @_;

    my %INSTALLED;

    print "$rpmquery $queryfmt $pkgs_to_query\n" if $VERBOSE >= 3;
    my(@rpmout) = `$rpmquery $queryfmt $pkgs_to_query 2>1`;
    chomp(@rpmout);
    for my $answer (@rpmout) {
        my($name,$version,$release,@rest) = split(/ /,$answer);
        print "name \"$name\" ".
              "version \"$version\" ".
              "release \"$release\" ".
              "rest \"@rest\"\n"
               if $VERBOSE >= 2;
        if ($name ne "package") {
            $INSTALLED{$name} = [$version, $release];
        }
    }

    if ($VERBOSE >= 2) {
        print "\nInstalled Packages:\n".
              "===================\n";
        if (!keys %INSTALLED) { print "--None--\n"; }
        else
        {
            for my $pkg (keys %INSTALLED)
            {
                my($version,$release) = @{$INSTALLED{$pkg}};
                if ($version ne "") { print "$pkg $version $release\n"; }
            }
        }
        print "\n\n";
    }

    return %INSTALLED;
}

1;
